using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using System.Text;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{

	#region Header

		//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		//<Developers>
		//	<Developer>Margaret Jablonski</Developer>
		//</Developers>
		//<SiteName>Hines OIFO</SiteName>
		//<CreationDate>5/7/2004</CreationDate>
		//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		//<summary></summary>

		#endregion

	/// <summary>
	/// Class FrmAboIncompatibleTransfusion
	/// </summary>
	public class FrmAboIncompatibleTransfusion : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// Minimum volume that may be transfused
		/// Implements BR_69.08
		/// </summary>
		private const int _minTransfusedVolume = 1;

		/// <summary>
		/// Is form loading
		/// </summary>
		private bool _isLoading;

		/// <summary>
		/// Used to avoid calling method twice
		/// </summary>
		private bool _isUpdatingTransfusedVolume;

		/// <summary>
		/// Current working Patient Transfusion object
		/// </summary>
		private BOL.PatientTransfusion _patientTransfusion;

		/// <summary>
		/// Current working Blood Unit object
		/// </summary>
		private BOL.BloodUnit _bloodUnit;

		private Common.WorkloadProcessID _workloadProcessId = Common.WorkloadProcessID.TransfuseUnit;

		//private double _originalVolume;

		#endregion
		
		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpWarninng;
		private System.Windows.Forms.GroupBox grpPostTransfusionInfo;
		private System.Windows.Forms.GroupBox grpCompleted;
		private System.Windows.Forms.RadioButton rdoCompleted;
		private System.Windows.Forms.RadioButton rdoInterrupted;
		private System.Windows.Forms.GroupBox grpInterrupted;
		private System.Windows.Forms.Panel pnlAmountTransfused;
		private System.Windows.Forms.Label lblmL;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updmL;
		private System.Windows.Forms.Label lblAmountTransfused;
		private System.Windows.Forms.RadioButton rdoQuarter;
		private System.Windows.Forms.RadioButton rdoHalf;
		private System.Windows.Forms.RadioButton rdoThreeQuarter;
		private System.Windows.Forms.RadioButton rdoVolume;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPatientLocation;
		private System.Windows.Forms.Label lblPatientLocation;
		private System.Windows.Forms.DateTimePicker dtpTransfusionEndDate;
		private System.Windows.Forms.Label lblTransfusionDate;
		private System.Windows.Forms.GroupBox grpReactionNoted;
		private System.Windows.Forms.RadioButton rdoNoReaction;
		private System.Windows.Forms.RadioButton rdoReactionNoted;
		private System.Windows.Forms.GroupBox grpSymptoms;
		private System.Windows.Forms.TextBox txtSymptoms;
		private System.Windows.Forms.Label lblSymptoms;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.Label lblComments;
		private System.Windows.Forms.Label lblWarning;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private System.Windows.Forms.Panel pnlPatientSelect;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.Button btnCancelPatient;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOKPatient;
        private System.Windows.Forms.Panel pnlTransfusion;
		private System.Windows.Forms.DateTimePicker dtpTransfusionStartDate;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox grpTrnsImage;
		private System.Windows.Forms.PictureBox pictureBox2;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmAboIncompatibleTransfusion()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC069PostTransfusionInformation;

			this._isLoading = true;
			
			InitializeComponent();
			SetComponentProperties();
		
			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmAboIncompatibleTransfusion));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.grpWarninng = new System.Windows.Forms.GroupBox();
            this.lblWarning = new System.Windows.Forms.Label();
            this.grpPostTransfusionInfo = new System.Windows.Forms.GroupBox();
            this.dtpTransfusionStartDate = new System.Windows.Forms.DateTimePicker();
            this.label1 = new System.Windows.Forms.Label();
            this.grpCompleted = new System.Windows.Forms.GroupBox();
            this.rdoCompleted = new System.Windows.Forms.RadioButton();
            this.rdoInterrupted = new System.Windows.Forms.RadioButton();
            this.grpInterrupted = new System.Windows.Forms.GroupBox();
            this.pnlAmountTransfused = new System.Windows.Forms.Panel();
            this.lblmL = new System.Windows.Forms.Label();
            this.updmL = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
            this.lblAmountTransfused = new System.Windows.Forms.Label();
            this.rdoQuarter = new System.Windows.Forms.RadioButton();
            this.rdoHalf = new System.Windows.Forms.RadioButton();
            this.rdoThreeQuarter = new System.Windows.Forms.RadioButton();
            this.rdoVolume = new System.Windows.Forms.RadioButton();
            this.cmbPatientLocation = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPatientLocation = new System.Windows.Forms.Label();
            this.dtpTransfusionEndDate = new System.Windows.Forms.DateTimePicker();
            this.lblTransfusionDate = new System.Windows.Forms.Label();
            this.grpReactionNoted = new System.Windows.Forms.GroupBox();
            this.rdoNoReaction = new System.Windows.Forms.RadioButton();
            this.rdoReactionNoted = new System.Windows.Forms.RadioButton();
            this.grpSymptoms = new System.Windows.Forms.GroupBox();
            this.txtSymptoms = new System.Windows.Forms.TextBox();
            this.lblSymptoms = new System.Windows.Forms.Label();
            this.txtComments = new System.Windows.Forms.TextBox();
            this.lblComments = new System.Windows.Forms.Label();
            this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
            this.pnlPatientSelect = new System.Windows.Forms.Panel();
            this.btnOKPatient = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancelPatient = new System.Windows.Forms.Button();
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            this.pnlTransfusion = new System.Windows.Forms.Panel();
            this.grpTrnsImage = new System.Windows.Forms.GroupBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpWarninng.SuspendLayout();
            this.grpPostTransfusionInfo.SuspendLayout();
            this.grpCompleted.SuspendLayout();
            this.grpInterrupted.SuspendLayout();
            this.pnlAmountTransfused.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.updmL)).BeginInit();
            this.grpReactionNoted.SuspendLayout();
            this.grpSymptoms.SuspendLayout();
            this.pnlPatientSelect.SuspendLayout();
            this.pnlTransfusion.SuspendLayout();
            this.grpTrnsImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Document ABO Incompatible Transfusion";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(532, 348);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 3;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.btnCancel.Location = new System.Drawing.Point(612, 348);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 4;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // grpWarninng
            // 
            this.grpWarninng.AccessibleDescription = resources.GetString("grpWarninng.AccessibleDescription");
            this.grpWarninng.AccessibleName = resources.GetString("grpWarninng.AccessibleName");
            this.grpWarninng.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpWarninng.Controls.Add(this.lblWarning);
            this.grpWarninng.Location = new System.Drawing.Point(48, 28);
            this.grpWarninng.Name = "grpWarninng";
            this.grpWarninng.Size = new System.Drawing.Size(640, 64);
            this.grpWarninng.TabIndex = 3;
            this.grpWarninng.TabStop = false;
            // 
            // lblWarning
            // 
            this.lblWarning.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblWarning.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblWarning.Location = new System.Drawing.Point(4, 8);
            this.lblWarning.Name = "lblWarning";
            this.lblWarning.Size = new System.Drawing.Size(632, 52);
            this.lblWarning.TabIndex = 0;
            this.lblWarning.Text = resources.GetString("lblWarning.Text");
            this.lblWarning.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // grpPostTransfusionInfo
            // 
            this.grpPostTransfusionInfo.AccessibleDescription = "Post Transfusion Information";
            this.grpPostTransfusionInfo.AccessibleName = "Post Transfusion Information";
            this.grpPostTransfusionInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPostTransfusionInfo.Controls.Add(this.dtpTransfusionStartDate);
            this.grpPostTransfusionInfo.Controls.Add(this.label1);
            this.grpPostTransfusionInfo.Controls.Add(this.grpCompleted);
            this.grpPostTransfusionInfo.Controls.Add(this.cmbPatientLocation);
            this.grpPostTransfusionInfo.Controls.Add(this.lblPatientLocation);
            this.grpPostTransfusionInfo.Controls.Add(this.dtpTransfusionEndDate);
            this.grpPostTransfusionInfo.Controls.Add(this.lblTransfusionDate);
            this.grpPostTransfusionInfo.Controls.Add(this.grpReactionNoted);
            this.grpPostTransfusionInfo.Controls.Add(this.txtComments);
            this.grpPostTransfusionInfo.Controls.Add(this.lblComments);
            this.grpPostTransfusionInfo.Location = new System.Drawing.Point(268, 40);
            this.grpPostTransfusionInfo.Name = "grpPostTransfusionInfo";
            this.grpPostTransfusionInfo.Size = new System.Drawing.Size(420, 304);
            this.grpPostTransfusionInfo.TabIndex = 2;
            this.grpPostTransfusionInfo.TabStop = false;
            this.grpPostTransfusionInfo.Text = "Post-Transfusion Information";
            // 
            // dtpTransfusionStartDate
            // 
            this.dtpTransfusionStartDate.AccessibleDescription = "Transfusion Start Date";
            this.dtpTransfusionStartDate.AccessibleName = "Transfusion Start Date";
            this.dtpTransfusionStartDate.CustomFormat = "MM/dd/yyyy hh:mm";
            this.dtpTransfusionStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpTransfusionStartDate.Location = new System.Drawing.Point(176, 16);
            this.dtpTransfusionStartDate.Name = "dtpTransfusionStartDate";
            this.dtpTransfusionStartDate.Size = new System.Drawing.Size(120, 20);
            this.dtpTransfusionStartDate.TabIndex = 1;
            this.dtpTransfusionStartDate.ValueChanged += new System.EventHandler(this.dtpTransfusionStartDate_ValueChanged);
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(8, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(128, 20);
            this.label1.TabIndex = 0;
            this.label1.Text = "Transfusion Start Date*";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpCompleted
            // 
            this.grpCompleted.AccessibleDescription = "Transfusion Completed";
            this.grpCompleted.AccessibleName = "Transfusion Completed";
            this.grpCompleted.Controls.Add(this.rdoCompleted);
            this.grpCompleted.Controls.Add(this.rdoInterrupted);
            this.grpCompleted.Controls.Add(this.grpInterrupted);
            this.grpCompleted.Location = new System.Drawing.Point(8, 88);
            this.grpCompleted.Name = "grpCompleted";
            this.grpCompleted.Size = new System.Drawing.Size(172, 156);
            this.grpCompleted.TabIndex = 6;
            this.grpCompleted.TabStop = false;
            this.grpCompleted.Text = "Transfusion Completed?*";
            // 
            // rdoCompleted
            // 
            this.rdoCompleted.AccessibleDescription = "Transfusion Completed";
            this.rdoCompleted.AccessibleName = "Transfusion Completed";
            this.rdoCompleted.Checked = true;
            this.rdoCompleted.Location = new System.Drawing.Point(12, 16);
            this.rdoCompleted.Name = "rdoCompleted";
            this.rdoCompleted.Size = new System.Drawing.Size(144, 16);
            this.rdoCompleted.TabIndex = 0;
            this.rdoCompleted.TabStop = true;
            this.rdoCompleted.Text = "&Transfusion Completed";
            this.rdoCompleted.CheckedChanged += new System.EventHandler(this.rdoCompleted_CheckedChanged);
            // 
            // rdoInterrupted
            // 
            this.rdoInterrupted.AccessibleDescription = "Transfusion Interrupted";
            this.rdoInterrupted.AccessibleName = "Transfusion Interrupted";
            this.rdoInterrupted.Location = new System.Drawing.Point(12, 36);
            this.rdoInterrupted.Name = "rdoInterrupted";
            this.rdoInterrupted.Size = new System.Drawing.Size(144, 16);
            this.rdoInterrupted.TabIndex = 1;
            this.rdoInterrupted.Text = "Transfusion &Interrupted";
            this.rdoInterrupted.CheckedChanged += new System.EventHandler(this.rdoInterrupted_CheckedChanged);
            // 
            // grpInterrupted
            // 
            this.grpInterrupted.AccessibleDescription = "Transfusion interupted";
            this.grpInterrupted.AccessibleName = "Transfusion interupted";
            this.grpInterrupted.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpInterrupted.Controls.Add(this.pnlAmountTransfused);
            this.grpInterrupted.Location = new System.Drawing.Point(8, 36);
            this.grpInterrupted.Name = "grpInterrupted";
            this.grpInterrupted.Size = new System.Drawing.Size(158, 112);
            this.grpInterrupted.TabIndex = 2;
            this.grpInterrupted.TabStop = false;
            // 
            // pnlAmountTransfused
            // 
            this.pnlAmountTransfused.AccessibleDescription = "Amount Transfused";
            this.pnlAmountTransfused.AccessibleName = "Amount Transfused";
            this.pnlAmountTransfused.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlAmountTransfused.Controls.Add(this.lblmL);
            this.pnlAmountTransfused.Controls.Add(this.updmL);
            this.pnlAmountTransfused.Controls.Add(this.lblAmountTransfused);
            this.pnlAmountTransfused.Controls.Add(this.rdoQuarter);
            this.pnlAmountTransfused.Controls.Add(this.rdoHalf);
            this.pnlAmountTransfused.Controls.Add(this.rdoThreeQuarter);
            this.pnlAmountTransfused.Controls.Add(this.rdoVolume);
            this.pnlAmountTransfused.Location = new System.Drawing.Point(4, 16);
            this.pnlAmountTransfused.Name = "pnlAmountTransfused";
            this.pnlAmountTransfused.Size = new System.Drawing.Size(152, 92);
            this.pnlAmountTransfused.TabIndex = 0;
            // 
            // lblmL
            // 
            this.lblmL.Location = new System.Drawing.Point(116, 72);
            this.lblmL.Name = "lblmL";
            this.lblmL.Size = new System.Drawing.Size(20, 20);
            this.lblmL.TabIndex = 6;
            this.lblmL.Text = "mL";
            this.lblmL.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // updmL
            // 
            this.updmL.AccessibleDescription = "volume milliliters";
            this.updmL.AccessibleName = "volume milliliters";
            this.updmL.Location = new System.Drawing.Point(72, 72);
            this.updmL.Maximum = new decimal(new int[] {
            2000,
            0,
            0,
            0});
            this.updmL.Name = "updmL";
            this.updmL.Size = new System.Drawing.Size(46, 20);
            this.updmL.TabIndex = 5;
            this.updmL.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.updmL.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.updmL.TextChanged += new System.EventHandler(this.updmL_ValueChanged);
            this.updmL.ValueChanged += new System.EventHandler(this.updmL_ValueChanged);
            this.updmL.Leave += new System.EventHandler(this.updmL_Leave);
            // 
            // lblAmountTransfused
            // 
            this.lblAmountTransfused.Location = new System.Drawing.Point(16, 0);
            this.lblAmountTransfused.Name = "lblAmountTransfused";
            this.lblAmountTransfused.Size = new System.Drawing.Size(112, 16);
            this.lblAmountTransfused.TabIndex = 0;
            this.lblAmountTransfused.Text = "Amount Transfused*";
            this.lblAmountTransfused.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // rdoQuarter
            // 
            this.rdoQuarter.AccessibleDescription = "quarter";
            this.rdoQuarter.AccessibleName = "quarter";
            this.rdoQuarter.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoQuarter.Location = new System.Drawing.Point(16, 16);
            this.rdoQuarter.Name = "rdoQuarter";
            this.rdoQuarter.Size = new System.Drawing.Size(44, 20);
            this.rdoQuarter.TabIndex = 1;
            this.rdoQuarter.TabStop = true;
            this.rdoQuarter.Text = "&1/4";
            this.rdoQuarter.CheckedChanged += new System.EventHandler(this.rdoQuarter_CheckedChanged);
            // 
            // rdoHalf
            // 
            this.rdoHalf.AccessibleDescription = "half";
            this.rdoHalf.AccessibleName = "half";
            this.rdoHalf.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoHalf.Location = new System.Drawing.Point(16, 36);
            this.rdoHalf.Name = "rdoHalf";
            this.rdoHalf.Size = new System.Drawing.Size(40, 20);
            this.rdoHalf.TabIndex = 2;
            this.rdoHalf.Text = "1/&2";
            this.rdoHalf.CheckedChanged += new System.EventHandler(this.rdoHalf_CheckedChanged);
            // 
            // rdoThreeQuarter
            // 
            this.rdoThreeQuarter.AccessibleDescription = "three quarter";
            this.rdoThreeQuarter.AccessibleName = "three quarter";
            this.rdoThreeQuarter.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoThreeQuarter.Location = new System.Drawing.Point(16, 56);
            this.rdoThreeQuarter.Name = "rdoThreeQuarter";
            this.rdoThreeQuarter.Size = new System.Drawing.Size(40, 20);
            this.rdoThreeQuarter.TabIndex = 3;
            this.rdoThreeQuarter.Text = "&3/4";
            this.rdoThreeQuarter.CheckedChanged += new System.EventHandler(this.rdoThreeQuarter_CheckedChanged);
            // 
            // rdoVolume
            // 
            this.rdoVolume.AccessibleDescription = "Volume milliliters";
            this.rdoVolume.AccessibleName = "Volume milliliters";
            this.rdoVolume.Location = new System.Drawing.Point(16, 76);
            this.rdoVolume.Name = "rdoVolume";
            this.rdoVolume.Size = new System.Drawing.Size(64, 20);
            this.rdoVolume.TabIndex = 4;
            this.rdoVolume.Text = "&Volume";
            this.rdoVolume.CheckedChanged += new System.EventHandler(this.rdoVolume_CheckedChanged);
            // 
            // cmbPatientLocation
            // 
            this.cmbPatientLocation.AccessibleDescription = "Patient Location at Transfusion";
            this.cmbPatientLocation.AccessibleName = "Patient Location at Transfusion";
            this.cmbPatientLocation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPatientLocation.Enabled = false;
            this.cmbPatientLocation.Interval = 500;
            this.cmbPatientLocation.Location = new System.Drawing.Point(176, 64);
            this.cmbPatientLocation.Name = "cmbPatientLocation";
            this.cmbPatientLocation.Size = new System.Drawing.Size(236, 22);
            this.cmbPatientLocation.TabIndex = 5;
            this.cmbPatientLocation.SelectedIndexChanged += new System.EventHandler(this.cmbPatientLocation_SelectedIndexChanged);
            // 
            // lblPatientLocation
            // 
            this.lblPatientLocation.Location = new System.Drawing.Point(8, 64);
            this.lblPatientLocation.Name = "lblPatientLocation";
            this.lblPatientLocation.Size = new System.Drawing.Size(168, 20);
            this.lblPatientLocation.TabIndex = 4;
            this.lblPatientLocation.Text = "Patient Location at Transfusion*";
            this.lblPatientLocation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpTransfusionEndDate
            // 
            this.dtpTransfusionEndDate.AccessibleDescription = "Transfusion End Date";
            this.dtpTransfusionEndDate.AccessibleName = "Transfusion End Date";
            this.dtpTransfusionEndDate.CustomFormat = "MM/dd/yyyy hh:mm";
            this.dtpTransfusionEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpTransfusionEndDate.Location = new System.Drawing.Point(176, 40);
            this.dtpTransfusionEndDate.Name = "dtpTransfusionEndDate";
            this.dtpTransfusionEndDate.Size = new System.Drawing.Size(120, 20);
            this.dtpTransfusionEndDate.TabIndex = 3;
            this.dtpTransfusionEndDate.ValueChanged += new System.EventHandler(this.dtpTransfusionEndDate_ValueChanged);
            // 
            // lblTransfusionDate
            // 
            this.lblTransfusionDate.Location = new System.Drawing.Point(8, 40);
            this.lblTransfusionDate.Name = "lblTransfusionDate";
            this.lblTransfusionDate.Size = new System.Drawing.Size(120, 20);
            this.lblTransfusionDate.TabIndex = 2;
            this.lblTransfusionDate.Text = "Transfusion End Date*";
            this.lblTransfusionDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpReactionNoted
            // 
            this.grpReactionNoted.AccessibleDescription = "Transfusion Reaction Noted";
            this.grpReactionNoted.AccessibleName = "Transfusion Reaction Noted";
            this.grpReactionNoted.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpReactionNoted.Controls.Add(this.rdoNoReaction);
            this.grpReactionNoted.Controls.Add(this.rdoReactionNoted);
            this.grpReactionNoted.Controls.Add(this.grpSymptoms);
            this.grpReactionNoted.Location = new System.Drawing.Point(184, 88);
            this.grpReactionNoted.Name = "grpReactionNoted";
            this.grpReactionNoted.Size = new System.Drawing.Size(228, 156);
            this.grpReactionNoted.TabIndex = 7;
            this.grpReactionNoted.TabStop = false;
            this.grpReactionNoted.Text = "Transfusion Reaction Noted?*";
            // 
            // rdoNoReaction
            // 
            this.rdoNoReaction.AccessibleDescription = "No reaction";
            this.rdoNoReaction.AccessibleName = "No reaction";
            this.rdoNoReaction.Location = new System.Drawing.Point(12, 16);
            this.rdoNoReaction.Name = "rdoNoReaction";
            this.rdoNoReaction.Size = new System.Drawing.Size(100, 16);
            this.rdoNoReaction.TabIndex = 0;
            this.rdoNoReaction.TabStop = true;
            this.rdoNoReaction.Text = "&No Reaction";
            this.rdoNoReaction.CheckedChanged += new System.EventHandler(this.rdoNoReaction_CheckedChanged);
            // 
            // rdoReactionNoted
            // 
            this.rdoReactionNoted.AccessibleDescription = "reaction noted";
            this.rdoReactionNoted.AccessibleName = "reaction noted";
            this.rdoReactionNoted.Location = new System.Drawing.Point(12, 36);
            this.rdoReactionNoted.Name = "rdoReactionNoted";
            this.rdoReactionNoted.Size = new System.Drawing.Size(104, 16);
            this.rdoReactionNoted.TabIndex = 1;
            this.rdoReactionNoted.Text = "&Reaction Noted";
            this.rdoReactionNoted.CheckedChanged += new System.EventHandler(this.rdoReactionNoted_CheckedChanged);
            // 
            // grpSymptoms
            // 
            this.grpSymptoms.AccessibleDescription = "Reaction Noted";
            this.grpSymptoms.AccessibleName = "Reaction Noted";
            this.grpSymptoms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSymptoms.Controls.Add(this.txtSymptoms);
            this.grpSymptoms.Controls.Add(this.lblSymptoms);
            this.grpSymptoms.Location = new System.Drawing.Point(8, 36);
            this.grpSymptoms.Name = "grpSymptoms";
            this.grpSymptoms.Size = new System.Drawing.Size(214, 112);
            this.grpSymptoms.TabIndex = 2;
            this.grpSymptoms.TabStop = false;
            // 
            // txtSymptoms
            // 
            this.txtSymptoms.AccessibleDescription = "symptoms";
            this.txtSymptoms.AccessibleName = "symptoms";
            this.txtSymptoms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSymptoms.Location = new System.Drawing.Point(20, 32);
            this.txtSymptoms.MaxLength = 255;
            this.txtSymptoms.Multiline = true;
            this.txtSymptoms.Name = "txtSymptoms";
            this.txtSymptoms.Size = new System.Drawing.Size(184, 72);
            this.txtSymptoms.TabIndex = 1;
            this.txtSymptoms.TextChanged += new System.EventHandler(this.txtSymptoms_TextChanged);
            // 
            // lblSymptoms
            // 
            this.lblSymptoms.Location = new System.Drawing.Point(20, 16);
            this.lblSymptoms.Name = "lblSymptoms";
            this.lblSymptoms.Size = new System.Drawing.Size(60, 20);
            this.lblSymptoms.TabIndex = 0;
            this.lblSymptoms.Text = "Symptoms";
            this.lblSymptoms.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtComments
            // 
            this.txtComments.AccessibleDescription = "comments";
            this.txtComments.AccessibleName = "comments";
            this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtComments.Location = new System.Drawing.Point(8, 260);
            this.txtComments.MaxLength = 255;
            this.txtComments.Multiline = true;
            this.txtComments.Name = "txtComments";
            this.txtComments.Size = new System.Drawing.Size(404, 36);
            this.txtComments.TabIndex = 9;
            this.txtComments.TextChanged += new System.EventHandler(this.txtComments_TextChanged);
            // 
            // lblComments
            // 
            this.lblComments.Location = new System.Drawing.Point(8, 244);
            this.lblComments.Name = "lblComments";
            this.lblComments.Size = new System.Drawing.Size(76, 20);
            this.lblComments.TabIndex = 8;
            this.lblComments.Text = "Comments";
            this.lblComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // bloodUnitSelectorVertical1
            // 
            this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
            this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(4, 40);
            this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
            this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 308);
            this.bloodUnitSelectorVertical1.TabIndex = 1;
            this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelector1_SearchClick);
            this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelector1_ClearBtnClick);
            this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelector1_UnitUpdate);
            // 
            // pnlPatientSelect
            // 
            this.pnlPatientSelect.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPatientSelect.Controls.Add(this.btnOKPatient);
            this.pnlPatientSelect.Controls.Add(this.btnCancelPatient);
            this.pnlPatientSelect.Controls.Add(this.patientSelectTool1);
            this.pnlPatientSelect.Location = new System.Drawing.Point(0, 92);
            this.pnlPatientSelect.Name = "pnlPatientSelect";
            this.pnlPatientSelect.Size = new System.Drawing.Size(692, 372);
            this.pnlPatientSelect.TabIndex = 0;
            // 
            // btnOKPatient
            // 
            this.btnOKPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOKPatient.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOKPatient.Image = null;
            this.btnOKPatient.Location = new System.Drawing.Point(532, 348);
            this.btnOKPatient.Name = "btnOKPatient";
            this.btnOKPatient.Size = new System.Drawing.Size(75, 23);
            this.btnOKPatient.TabIndex = 1;
            this.btnOKPatient.Click += new System.EventHandler(this.btnOKPatient_Click);
            this.btnOKPatient.MouseHover += new System.EventHandler(this.btnOKPatient_MouseHover);
            // 
            // btnCancelPatient
            // 
            this.btnCancelPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancelPatient.Location = new System.Drawing.Point(612, 348);
            this.btnCancelPatient.Name = "btnCancelPatient";
            this.btnCancelPatient.Size = new System.Drawing.Size(75, 23);
            this.btnCancelPatient.TabIndex = 2;
            this.btnCancelPatient.Text = "&Cancel";
            this.btnCancelPatient.Click += new System.EventHandler(this.btnCancelPatient_Click);
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.AccessibleDescription = resources.GetString("patientSelectTool1.AccessibleDescription");
            this.patientSelectTool1.AccessibleName = resources.GetString("patientSelectTool1.AccessibleName");
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.hlphelpChm.SetHelpKeyword(this.patientSelectTool1, "Document_ABO-Incompatible_Transfusion.htm");
            this.hlphelpChm.SetHelpNavigator(this.patientSelectTool1, System.Windows.Forms.HelpNavigator.Topic);
            this.patientSelectTool1.Location = new System.Drawing.Point(4, 0);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.hlphelpChm.SetShowHelp(this.patientSelectTool1, true);
            this.patientSelectTool1.Size = new System.Drawing.Size(684, 344);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            // 
            // pnlTransfusion
            // 
            this.pnlTransfusion.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlTransfusion.Controls.Add(this.patientDisplayPanel1);
            this.pnlTransfusion.Controls.Add(this.bloodUnitSelectorVertical1);
            this.pnlTransfusion.Controls.Add(this.grpPostTransfusionInfo);
            this.pnlTransfusion.Controls.Add(this.btnOK);
            this.pnlTransfusion.Controls.Add(this.btnCancel);
            this.pnlTransfusion.Location = new System.Drawing.Point(0, 92);
            this.pnlTransfusion.Name = "pnlTransfusion";
            this.pnlTransfusion.Size = new System.Drawing.Size(692, 372);
            this.pnlTransfusion.TabIndex = 1;
            // 
            // grpTrnsImage
            // 
            this.grpTrnsImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpTrnsImage.Controls.Add(this.pictureBox2);
            this.grpTrnsImage.Location = new System.Drawing.Point(4, 28);
            this.grpTrnsImage.Name = "grpTrnsImage";
            this.grpTrnsImage.Size = new System.Drawing.Size(40, 64);
            this.grpTrnsImage.TabIndex = 2;
            this.grpTrnsImage.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 12);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(32, 36);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox2.TabIndex = 1;
            this.pictureBox2.TabStop = false;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 0);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(686, 44);
            this.patientDisplayPanel1.TabIndex = 5;
            // 
            // FrmAboIncompatibleTransfusion
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(692, 473);
            this.Controls.Add(this.grpWarninng);
            this.Controls.Add(this.pnlTransfusion);
            this.Controls.Add(this.pnlPatientSelect);
            this.Controls.Add(this.grpTrnsImage);
            this.hlphelpChm.SetHelpKeyword(this, "Document_ABO-Incompatible_Transfusion.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(700, 500);
            this.Name = "FrmAboIncompatibleTransfusion";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Document ABO Incompatible Transfusion";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmAboIncompatibleTransfusion_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmAboIncompatibleTransfusion_Load);
            this.Controls.SetChildIndex(this.grpTrnsImage, 0);
            this.Controls.SetChildIndex(this.pnlPatientSelect, 0);
            this.Controls.SetChildIndex(this.pnlTransfusion, 0);
            this.Controls.SetChildIndex(this.grpWarninng, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpWarninng.ResumeLayout(false);
            this.grpPostTransfusionInfo.ResumeLayout(false);
            this.grpPostTransfusionInfo.PerformLayout();
            this.grpCompleted.ResumeLayout(false);
            this.grpInterrupted.ResumeLayout(false);
            this.pnlAmountTransfused.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.updmL)).EndInit();
            this.grpReactionNoted.ResumeLayout(false);
            this.grpSymptoms.ResumeLayout(false);
            this.grpSymptoms.PerformLayout();
            this.pnlPatientSelect.ResumeLayout(false);
            this.pnlTransfusion.ResumeLayout(false);
            this.grpTrnsImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Events / Event Handlers

		/// <summary>
		/// Form Load
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void FrmAboIncompatibleTransfusion_Load(object sender, System.EventArgs e)
		{
			this.IsDirty = false;
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/10/2004</CreationDate>
		///
		/// <summary>
		/// Patient selected event handler, enables the OK button and sets tooltip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			if(!(this._isLoading))
			{
				this.btnOKPatient.EnabledButton = true;
				this.btnOKPatient.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/10/2004</CreationDate>
		///
		/// <summary>
		/// Patient deselected event handler, disables the OK button and sets tooltip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>	
		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			if(!(this._isLoading))
			{
				this.btnOKPatient.EnabledButton = false;
				this.btnOKPatient.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, process the request
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Save();
		}


		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, process the request
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOKPatient_Click(object sender, System.EventArgs e)
		{
			//If Patient Select Tool was visible, show Select Unit and Post-Transfusion panel next
			if(this.pnlPatientSelect.Visible)
			{
				// searchVistaLink: don't make a trip to the DB if it's not needed:
				if( this.patientSelectTool1.SearchVistaLink && this.patientSelectTool1.SelectedPatientDataRow() != null )
				{
					if (!BOL.Patient.InsertPatient( this.patientSelectTool1.SelectedPatientDataRow(), Common.UpdateFunction.UC069FrmAboIncompatibleTransfusion ))
					{
						GuiMessenger.ShowMessageBox(this,Common.StrRes.SysErrMsg.Common.DataSaveError("Patient", this.patientSelectTool1.SelectedPatient.LastName, this.patientSelectTool1.SelectedPatient.FirstName));
						return;
					}
				}
				//
				this.pnlTransfusion.BringToFront();

				//Set Panels visibility property
				this.pnlPatientSelect.Visible = false;
				this.pnlTransfusion.Visible = true;
				this.pnlAmountTransfused.Visible = true;
				this.bloodUnitSelectorVertical1.Visible = true;
				this.patientDisplayPanel1.Visible = true;

				//Assign patient information to the control
				this.patientDisplayPanel1.Patient = this.patientSelectTool1.SelectedPatient;

				//Enable/disabel controls
				this.cmbPatientLocation.Enabled = true;
				this.pnlAmountTransfused.Enabled = false;
				this.grpPostTransfusionInfo.Enabled = false;

				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmAboIncompatibleTransfusion());
			}
	
		}

		private void btnOKPatient_MouseHover(object sender, System.EventArgs e)
		{
			//Show tooltip depending what panel is visible. Only available on disabled button
			if (this.btnOKPatient.EnabledButton == false && this.pnlPatientSelect.Visible == true)
			{
				this.ttToolTip.SetToolTip(this.btnOKPatient, Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			}		
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler, closes the form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancelPatient_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();		
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler, closes the form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// This clears the UnitId and productCode fields
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_ClearBtnClick(object sender, System.EventArgs e)
		{
			this.SetControlData(false);
			
			this.UnlockAllRecords();

			//Resetting everything on the page including the dirty value
			this.bloodUnitSelectorVertical1.DisplayBloodUnit("", "");
			this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***

			//clear broken rules if the object has been already loaded
			if(this._patientTransfusion != null)
			{
				this._patientTransfusion.SetInitialBrokenRules(this.Name, "default" ,true);
			}
			//Have to reset the button again here becasue the Broken rules reset enables it
            this.btnOK.EnabledButton = false;
						
			//Set state of these three controls
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = false;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = false;
			this.grpPostTransfusionInfo.Enabled = false;

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmAboIncompatibleTransfusion());

			this.IsDirty = false;
		}

		/// <summary>
		/// When the user clicks the search button on the blood unit selector
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_SearchClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					this.Working();

					//Get a list of valid units for this division to prepopulate UC5
					DataTable eligDt = BOL.BloodUnitFinance.GetFinancialBloodUnits();
					
					if(eligDt.Rows.Count > 0 )
					{
						//Create a new dialog window and set the required properties...
						DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
						unitSelector.MultiSelect = false;
						unitSelector.TitleBarText = "VBECS - Select Unit for Documenting ABO Incompatible Transfusion";
						unitSelector.LogoBarText = "Select Unit for Documenting ABO Incompatible Transfusion";

						unitSelector.ShowDialogFromLockedParent(this,false);
					
						//If everything went ok, we'll just grab the top row and populate our little BloodUnitSelector
						if (unitSelector.DialogResult == DialogResult.OK)
						{
							this.Refresh();
							DataRow dr = unitSelector.SelectedUnits.Rows[0];
							this.bloodUnitSelectorVertical1.DisplayBloodUnit(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(), 
								dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
							this._bloodUnit = new BOL.BloodUnit((Guid) dr[Common.VbecsTables.BloodUnit.BloodUnitGuid]);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.NoValidUnits());
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
				finally
				{
					this.Ready();
				}
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// When the unit enters a valid product code and unit id
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_UnitUpdate(object sender, System.EventArgs e)
		{
			// CR3051: Disable the unit/product fields in the finally statement so it always gets called.
			try
			{
				this.GetPatientTransfusion();

				if (!this.SetLocks(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitStatus.BloodUnitStatusGuid))
					return;

				this.PopulateTransfusionLocation();
				this.SetControlData(true);
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
			
				this.grpPostTransfusionInfo.Enabled = true;

				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmAboIncompatibleTransfusion());
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, err.Message); // **** 508 Compliance ***
				this.SetControlData(false);
				this.grpPostTransfusionInfo.Enabled = false;
			}
			finally
			{
				this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = true;
				this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = true;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion Interrupted radio button check event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void rdoInterrupted_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					// Transfusion interrupted radio button checked
					if(this.rdoInterrupted.Checked) 
					{
						this.pnlAmountTransfused.Enabled = true;
						this._patientTransfusion.TransfusionInterrupted = rdoInterrupted.Checked;
						this.errError.SetVbecsError(this.rdoInterrupted, String.Empty); // **** 508 Compliance ***
					}
					else
					{
						this.pnlAmountTransfused.Enabled = false;
					}
					//
					if(this.rdoVolume.Checked)
					{			
						CheckUpdMlValue(sender, e);	
					}
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoReactionNoted, err.Message); // **** 508 Compliance ***
			}
		}
		
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// Reaction Noted radio button check event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void rdoReactionNoted_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.rdoReactionNoted.Checked) // Reaction Noted radio button checked
				{
					this._patientTransfusion.ReactionIndicator = rdoReactionNoted.Checked;
					this.txtSymptoms.Enabled = true;
				}
				else
				{
					this.txtSymptoms.Enabled = false;
				}
				//
				this.SetDirtyFlag(sender, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/10/2004</CreationDate>
		///
		/// <summary>
		/// Volume radio button check event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void rdoVolume_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				string warning = string.Empty;
				//
				if (this.rdoVolume.Checked) // Reaction Noted radio button checked
				{
					this.updmL.Enabled = true;
				}
				else
				{
					this.updmL.Enabled = false;
				}
				//
				CheckUpdMlValue(sender, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Event attached to the Valid/Invalid/IsDirtyChanged events of the PatientTransfusion object
		/// Enables the OK button if the record is valid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnValid(object sender, System.EventArgs e)
		{
			if (this._patientTransfusion.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
				btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.SetToolTip(this._patientTransfusion.GetBrokenRulesMessage(this.Name));
				btnOK.EnabledButton = false;
			}
		}
	
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// PatientLocation SelectedIndex has changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbPatientLocation_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPatientLocation.SelectedIndex > -1)
			{
				this._patientTransfusion.PatientLocation = cmbPatientLocation.Text;
				//
				this.SetDirtyFlag(sender, e);
			}
			else
			{
				this._patientTransfusion.PatientLocation = "";
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion Completed radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoCompleted_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading && this._patientTransfusion != null)
				{
					// Transfusion completed
					if (this.rdoCompleted.Checked) 
					{
						this.pnlAmountTransfused.Enabled = false;
						this._patientTransfusion.TransfusionInterrupted = false;
						this.errError.SetVbecsError(this.rdoInterrupted, String.Empty); // **** 508 Compliance ***
					}
					else
					{
						this.pnlAmountTransfused.Enabled = false;
					}
					// clear error for updmL since it is not relevant here
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					// and enable okay button
					this.btnOK.Enabled = true;
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoReactionNoted, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// No Reaction radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoNoReaction_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.rdoNoReaction.Checked) // No Reaction radio button checked
				{
					this.txtSymptoms.Enabled = false;
					this._patientTransfusion.ReactionIndicator = false;
				}
				//
				this.SetDirtyFlag(sender, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// 1/4 Amount Transfused radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoQuarter_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this._patientTransfusion.OriginalVolume * (decimal) 0.25))
						return;
					//
					this._patientTransfusion.TransfusedVolume = Convert.ToInt32(this._patientTransfusion.OriginalVolume * (decimal) 0.25);
					//
					this.errError.SetVbecsError(this.rdoQuarter, string.Empty); // **** 508 Compliance ***
					//
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					// enable okay button
					this.btnOK.Enabled = true;
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoQuarter, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// 1/2 Amount Transfused radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoHalf_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this._patientTransfusion.OriginalVolume * (decimal) 0.50))
						return;
					//
					this._patientTransfusion.TransfusedVolume = Convert.ToInt32(this._patientTransfusion.OriginalVolume * (decimal) 0.50);
					//
					this.errError.SetVbecsError(this.rdoHalf, string.Empty); // **** 508 Compliance ***
					//
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					// enable okay button
					this.btnOK.Enabled = true;
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoHalf, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// 3/4 Amount Transfused radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoThreeQuarter_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this._patientTransfusion.OriginalVolume * (decimal) 0.75))
						return;
					//
					this._patientTransfusion.TransfusedVolume = Convert.ToInt32(this._patientTransfusion.OriginalVolume * (decimal) 0.75);
					//
					this.errError.SetVbecsError(this.rdoThreeQuarter, string.Empty); // **** 508 Compliance ***
					//
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					// enable okay button
					this.btnOK.Enabled = true;
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoThreeQuarter, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Verify values are within acceptable range;
		/// warn if not
		/// Implements BR_69.08
		/// </summary>
		private void CheckUpdMlValue(object sender, System.EventArgs e)
		{
			string warning = string.Empty;
			//
			try
			{
				if(this.updmL.Value < _minTransfusedVolume)
				{
					warning = Common.StrRes.SysErrMsg.UC069.TransfusedVolumeTooLow().ResString;
				}
				else if(this.updmL.Value > this._bloodUnit.OriginalVolume)
				{
					warning = Common.StrRes.SysErrMsg.UC069.TransfusedVolumeExceeded(this._bloodUnit.OriginalVolume).ResString;
				}
				//
				this._patientTransfusion.TransfusedVolume = Convert.ToInt32(this.updmL.Value);
			}
			catch(FormatException err)
			{
				warning = err.Message;
			}
			//
			// **** 508 Compliance ***
			string currentError = this.errError.GetError(this.lblmL);
			if ((currentError != null && currentError.Length > 0 && currentError != warning) || (currentError == null || currentError.Length == 0))
			{
				this.errError.SetVbecsError(this.lblmL, warning); 
			}
			else
			{
				this.errError.SetVbecsError(this.lblmL, string.Empty); 
			}
			//
			if (!this._isLoading)
			{
				this.SetDirtyFlag(sender, e);
			}
			//
			this.btnOK.Enabled = (this.rdoVolume.Checked && this.errError.GetError(this.lblmL).Equals(string.Empty)) || !this.rdoVolume.Checked;
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Volume Transfused up/down control value changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void updmL_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading && !this._isUpdatingTransfusedVolume)
				{
					if (this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this.updmL.Value))
						return;
					//
					CheckUpdMlValue(sender, e);
				}
			}
			catch(FormatException)
			{
				this._patientTransfusion.TransfusedVolume = int.MinValue;
			}
		}

		/// <summary>
		/// This is to update the NumericUpDown, because if you type a value that is less than the minimum
		/// it won't update the control to the NumericUpDown.Minimum until you click one of the up/down arrows
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void updmL_Leave(object sender, EventArgs e)
		{
			// avoid running updmL_ValueChanged also
			this._isUpdatingTransfusedVolume = true;
			//
			try
			{
				if (this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this.updmL.Value))
				{
					this._isUpdatingTransfusedVolume = false;
					return;
				}
				//
				CheckUpdMlValue(sender, e);
			}
			catch(FormatException err)
			{
				this._patientTransfusion.TransfusedVolume = int.MinValue;
				this.errError.SetVbecsError(this.lblmL, err.Message); // **** 508 Compliance ***
			}
			//
			this._isUpdatingTransfusedVolume = false;
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Symptoms text changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtSymptoms_TextChanged(object sender, System.EventArgs e)
		{
			this._patientTransfusion.ReactionSymptoms = this.txtSymptoms.Text.Trim();
			//
			if (txtSymptoms.Text.Trim().Length > 0)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Comments text changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtComments_TextChanged(object sender, System.EventArgs e)
		{
			this._patientTransfusion.PatientTransfusionComment= this.txtComments.Text.Trim();
			//
			if (txtComments.Text.Trim().Length > 0)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion Start date changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpTransfusionStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._patientTransfusion.TransfusionStartDateTime = this.dtpTransfusionStartDate.Value;
				//
				this.SetDirtyFlag(sender, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion End date changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpTransfusionEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				this._patientTransfusion.TransfusionEndDateTime = this.dtpTransfusionEndDate.Value;
				//
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmAboIncompatibleTransfusion_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			
			string textToSpeak = string.Empty;			
											
			//
			if ( !this.btnOKPatient.EnabledButton && this.pnlPatientSelect.Visible )
			{
				textToSpeak = Common.StrRes.Tooltips.Common.SelectPatient().ResString;
			}	
			else if ( !this.btnOK.EnabledButton && this.pnlTransfusion.Visible )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			if (textToSpeak != "")
				textToSpeak += "\n";
			textToSpeak += this.bloodUnitSelectorVertical1.GetErrorMessages();
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}
			if(this.patientSelectTool1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak,this.patientSelectTool1.GetErrorMessagesFor508());
			}
			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion

		#region Methods
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.btnOKPatient.EnabledButton = false;
			this.btnOKPatient.Text = "&OK";
			this.btnOK.Text = "&OK";

			this.btnOK.EnabledButton = false;

			//set custom date and time format
			this.dtpTransfusionEndDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpTransfusionStartDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//Default dates to division current datetime
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpTransfusionEndDate.Value = _currentDate;
			this.dtpTransfusionStartDate.Value = _currentDate;

			//Display Patient Select Tool control first
			this.pnlPatientSelect.BringToFront();
			this.pnlPatientSelect.Focus();

			//Set Panels visibility property
			this.pnlPatientSelect.Visible = true;
			this.pnlTransfusion.Visible = false;
			this.pnlAmountTransfused.Visible = false;
			this.bloodUnitSelectorVertical1.Visible = false;

			//Setting the property, needed for BR_69.15
			this.patientSelectTool1.SearchVistaLink = true;

			//Set the tooltips of the controls
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.ttToolTip.SetToolTip(this.btnCancelPatient, Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.EnterRequiredData().ResString); // **** 508 Compliance ***

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmAboIncompatibleTransfusion());
		}

		/// <summary>
		/// Update the form with/without values from the working _patientTransfusion object
		/// </summary>
		/// <param name="useObject"></param>
		private void SetControlData(bool useObject)
		{
			this._isLoading = true;

			this._isUpdatingTransfusedVolume = false;
			//
			if (useObject && this._patientTransfusion.IsNew != true)
			{
				//Set Transfusion Start Date - required field
				this.dtpTransfusionStartDate.Value = this._patientTransfusion.TransfusionStartDateTime;
				
				//Set Transfusion End Date - required field
				this.dtpTransfusionEndDate.Value = this._patientTransfusion.TransfusionEndDateTime;
				
				//Set Patient Location
				this.cmbPatientLocation.Text = this._patientTransfusion.PatientLocation;

				//Set Transfusion Completed Indicator
				if (this._patientTransfusion.TransfusionInterrupted != true)
				{
					this.rdoCompleted.Checked = true;
					this.rdoCompleted_CheckedChanged(this, EventArgs.Empty);
					this.rdoInterrupted.Checked = false;
					//And there is no volume
				}
				else
				{
					this.rdoCompleted.Checked = false;
					this.rdoInterrupted.Checked = true;
					this.pnlAmountTransfused.Enabled = true;

					//Set Transfused Volume - required field for Interupted transfusion
					if(this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this._patientTransfusion.OriginalVolume * (Decimal) 0.75))
					{
						this.rdoThreeQuarter.Checked = true;
						this.rdoHalf.Checked = false;
						this.rdoQuarter.Checked = false;
						this.rdoVolume.Checked = false;
						this.updmL.Value = 0;
					}
					else if(this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this._patientTransfusion.OriginalVolume * (Decimal) 0.50))
					{
						this.rdoThreeQuarter.Checked = false;
						this.rdoHalf.Checked = true;
						this.rdoQuarter.Checked = false;
						this.rdoVolume.Checked = false;
						this.updmL.Value = 0;
					}
					else if(this._patientTransfusion.TransfusedVolume == Convert.ToInt32(this._patientTransfusion.OriginalVolume * (Decimal) 0.25))
					{
						this.rdoThreeQuarter.Checked = false;
						this.rdoHalf.Checked = false;
						this.rdoQuarter.Checked = true;
						this.rdoVolume.Checked = false;
						this.updmL.Value = 0;
					}
					else
					{
						this.rdoThreeQuarter.Checked = false;
						this.rdoHalf.Checked = false;
						this.rdoQuarter.Checked = false;
						this.rdoVolume.Checked = true;
						this.updmL.Enabled = true;
						this.updmL.Value = this._patientTransfusion.TransfusedVolume;
					}
				}
				
				//Set Transfusion Reaction Indicator - required field
				if(this._patientTransfusion.ReactionIndicator == true)
				{
					this.rdoNoReaction.Checked = false;
					this.rdoReactionNoted.Checked = true;
				}
				else
				{
					this.rdoNoReaction.Checked = true;
					this.rdoReactionNoted.Checked = false;
					this.txtSymptoms.Enabled = false;
				}

				//Set Reaction Symptoms
				if(this._patientTransfusion.ReactionSymptoms != String.Empty)
				{
					this.txtSymptoms.Text = this._patientTransfusion.ReactionSymptoms;
				}

				//Set Comments
				if(this._patientTransfusion.PatientTransfusionComment != String.Empty)
				{
					this.txtComments.Text = this._patientTransfusion.PatientTransfusionComment;
				}

			}
			else
			{
				this.cmbPatientLocation.SelectedIndex = -1;
				this.rdoCompleted.Checked = true;
				this.rdoCompleted_CheckedChanged(this, EventArgs.Empty);
				this.rdoNoReaction.Checked = false;
				this.rdoReactionNoted.Checked = false;
				this.txtSymptoms.Enabled = false;
				this.txtSymptoms.Text = String.Empty;
				this.txtComments.Text = String.Empty;
				this.rdoHalf.Checked = false;
				this.rdoQuarter.Checked = false;
				this.rdoThreeQuarter.Checked = false;
				this.rdoVolume.Checked = false;
				this.updmL.Enabled = false;
				this.updmL.Value = 0;
			}

			this._isLoading = false;
		}

		/// <summary>
		/// Populate patient location at transfusion combo box.
		/// Defaults to the name of the issue to location (if the unit was issued).  
		/// </summary>
		private void PopulateTransfusionLocation()
		{
			ArrayList locations = this._patientTransfusion.GetLocations();

			//clear exisiting list
			this.cmbPatientLocation.Items.Clear();
			
			//Build the locations list
			if (locations.Count > 0) 
			{
				foreach(string location in locations)
				{
					this.cmbPatientLocation.Items.Add(location);
				}
			}
			//
			this.cmbPatientLocation.SelectedIndex = -1;
		}

		/// <summary>
		/// Gets a patient transfusion based on user input and attaches the events...
		/// </summary>
		private void GetPatientTransfusion()
		{
			if (!this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitStatus.IsFinal())
			{
				//Called when a new patient transfusion is being loaded.
				this.IsDirty = false;

				//Create the new patient transfusion 
				this._patientTransfusion = new BOL.PatientTransfusion(this.patientSelectTool1.SelectedPatient.PatientGuid ,this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid, true);

				// CR3052
				// We are obviously using VBECS to enter the transfusion record;
				// the other option would be 'BCE COTS' for records entered via
				// the BCE COTS application
				_patientTransfusion.ApplicationOfRecordId = Common.Utility.GetApplicationOfRecordTypeIntegerValue( Common.ApplicationOfRecordType.VBECS );

				//Attach events
				this._patientTransfusion.Invalid += new System.EventHandler(this.OnValid);
				this._patientTransfusion.Valid += new System.EventHandler(this.OnValid);
				this._patientTransfusion.IsDirtyChanged += new System.EventHandler(this.OnValid);
			
				//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
				//Everytime a property of the variable is altered and thus the form
				//has been changed in one way or another.
				this._patientTransfusion.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);


				if(this._patientTransfusion.IsNew == true)
				{
					this.btnOK.SetToolTip(string.Empty); //  **** 508 Compliance ***

					_patientTransfusion.SetInitialBrokenRules(this.Name, "default");
	
					//Assing default start and end date
					this._patientTransfusion.TransfusionStartDateTime = this.dtpTransfusionStartDate.Value;
					this._patientTransfusion.TransfusionEndDateTime = this.dtpTransfusionEndDate.Value;
				
					this.rdoCompleted.Checked = true;
					this.rdoCompleted_CheckedChanged(this, EventArgs.Empty);
				}
				else 
				{
					//edit existing record, no rules are broken when page loads
					_patientTransfusion.SetInitialBrokenRules(this.Name, "default" ,true);
				}
			
				this.OnValid(this, System.EventArgs.Empty);
			}
			else
			{
				//BR_70.06
				throw new BOL.BusinessObjectException(Common.StrRes.SysErrMsg.Common.UnitInFinalStatus().ResString);
			}

		}

		/// <summary>
		///  LoadOverrideCommentScreen   
		/// </summary>
		/// 
		/// <returns>
		///     A bool value, true if user entered a comment, or false if decided not to save this record
		/// </returns>
		private bool LoadOverrideCommentScreen()
		{
			DlgOverrideComment dlg = new DlgOverrideComment("ABO Incompatible", "Please enter a comment to override ABO Incompatible Transfusion", "AI");

			dlg.ShowDialogFromLockedParent(this,false);
			if (dlg.DialogResult == DialogResult.OK)
			{
				this._patientTransfusion.AboIncompatibleComment = dlg.Comment;
				dlg.Close();				
				return true;
			}
			else
			{
				//user canceled the Override comment window and we will not save data
				dlg.Close();
				return false;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/26/2002</CreationDate>
		///
		/// <summary>
		/// Private method to prompt user to save changes to file
		/// </summary>
		private void Save()
		{
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("ABO Incompatible Transfusion"));
			
			if (saveResult == DialogResult.Yes)
			{
				if(LoadOverrideCommentScreen())
				{
					try
					{
						//Since users can swich radio buttons back and forward, make sure we are only saving what needed.
						if(this.rdoCompleted.Checked)
						{
							this._patientTransfusion.TransfusedVolume = 0;
						}
						if(this.rdoNoReaction.Checked)
						{
							this._patientTransfusion.ReactionSymptoms = String.Empty;
						}
						if(this._patientTransfusion.Save(this._workloadProcessId))
						{
							this.IsDirty=false;
							this.Close();					
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("ABO Incompatible Transfusion"));
						}
					}
					catch(RowVersionException)
					{
						this.btnOK.RowVersionException = true;		//CR2077
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					}
				}
			}
		}


		#endregion
	}
}

